<?php
do
{
	if (!$vbulletin->options['dbtech_usertag_inlineusers'])
	{
		// Inline users disabled
		break;
	}

	if ($vbulletin->options['dbtech_usertag_disabledfeatures'] & 2)
	{
		// Tagging is disabled
		break;
	}
	
	if (!($vbulletin->options['dbtech_usertag_enabletaggedlist'] OR !isset($vbulletin->options['dbtech_usertag_enabletaggedlist'])))
	{
		// Tagged list is disabled
		break;
	}
	
	if ($vbulletin->options['dbtech_usertag_hideguests'] AND !$vbulletin->userinfo['userid'])
	{
		// Tagged list is disabled for guests
		break;
	}
	
	/*DBTECH_LITE_START*/
	// Lite-only
	$parentlist = explode(',', $foruminfo['parentlist']);
	if ($parentlist[0] == -1)
	{
		// This forum
		$noticeforum = $foruminfo['forumid'];		
	}
	else
	{
		$key = (count($parentlist) - 2);
		$noticeforum = $parentlist["$key"];
	}
	/*DBTECH_LITE_END*/
	
	
	
	if (!$vbulletin->forumcache[$noticeforum]['dbtech_usertag_enabletag'])
	{
		// Per-forum disable
		break;
	}
	
	if (!class_exists('vB_Template'))
	{
		// Ensure we have this
		require_once(DIR . '/dbtech/usertag/includes/class_template.php');
	}
	
	// Init this
	$taglist = array();
	
	$taglist_q = $db->query_read_slave("
		SELECT 	
			user.userid,
			user.username,
			user.usergroupid,
			user.membergroupids,
			user.infractiongroupid,
			user.displaygroupid
			" . ($vbulletin->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase" : '') . "
			FROM " . TABLE_PREFIX . "dbtech_usertag_tag AS tag
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = tag.taggedid)
			WHERE tag.threadid = " . intval($threadid) . "
			ORDER BY username ASC
			LIMIT " . $vbulletin->options['dbtech_usertag_inlineusers'] . "
	");
	while ($taglist_r = $db->fetch_array($taglist_q))
	{
		// Grab the markup username
		fetch_musername($taglist_r);
		
		if (intval($vbulletin->versionnumber) == 4)
		{
			// vB4 has SEO URLs
			$link = fetch_seo_url('member', $taglist_r);
		}
		else
		{
			// vB3 don't
			$link = "member.php?" . $vbulletin->session->vars['sessionurl'] . "u=$taglist_r[userid]";
		}
		
		// Set tag username
		$taglist[] = '<a href="' . $link . '" target="_blank">' . $taglist_r['musername'] . '</a>';
	}
	$db->free_result($taglist_q);
	unset($taglist_r);		
	
	// Ensure this is set
	$vbulletin->options['dbtech_usertag_taglist_position'] = (!isset($vbulletin->options['dbtech_usertag_taglist_position']) ? 1 : $vbulletin->options['dbtech_usertag_taglist_position']);
	
	// Template output
	$templater = vB_Template::create('dbtech_usertag_inlinetaglist');
		$templater->register('threadid', $threadid);
		$templater->register('taglist', implode(', ', $taglist));
	switch ($vbulletin->options['dbtech_usertag_taglist_position'])
	{
		case 1:
			// Before posts
			if (intval($vbulletin->versionnumber) == 3)
			{
				
				$poll .= $templater->render();
			}
			else
			{
				$template_hook['showthread_above_posts'] .= $templater->render();
			}
			break;
			
		case 2:
			// After posts
			$template_hook['showthread_after_activeusers'] .= $templater->render();
			break;
	}
}
while (false);
?>